/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2025 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
#pragma once

#include <string>
#include <cassert>

namespace batchedGemm {

namespace batchedGemm {

////////////////////////////////////////////////////////////////////////////////////////////////////

enum class RouteImpl {
  // No Routing
  NoRoute = 0,
  // Use LDGSTS to do the routing
  Ldgsts = 1,
  // Use UTMALDG.GATHER4 to do the routing
  Tma = 2
};

////////////////////////////////////////////////////////////////////////////////////////////////////

inline bool doesRouteImplUseNoRoute(RouteImpl mode) {
  return (mode == RouteImpl::NoRoute);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

inline bool doesRouteImplUseLdgsts(RouteImpl mode) {
  return (mode == RouteImpl::Ldgsts);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

inline bool doesRouteImplUseTma(RouteImpl mode) {
  return (mode == RouteImpl::Tma);
}

////////////////////////////////////////////////////////////////////////////////////////////////////

} // namespace batchedGemm

////////////////////////////////////////////////////////////////////////////////////////////////////

} // namespace batchedGemm
